class Vampire extends Mutator config(DanesSniperMod);

var config int MaxHealth;
var config bool bDrainHealth;
var config String DeathMessage;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	log("Mutator_DamageToScore Initialized");

	if ( bDrainHealth )
		{
		settimer(1.0, true);
		}

}

function Timer()
{
local Pawn P;
local Inventory inv;
local bool bSpawning;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		bSpawning = False;
		for (inv=P.Inventory; inv!=None; inv=inv.Inventory)
			{
			if ( inv.IsA('Spawnprotector') )
				{
				bSpawning = True;
				}
			}
		if ( P.Health == 1 && !P.PlayerReplicationInfo.bIsSpectator && !bSpawning)
			{
			P.TakeDamage(1, None, P.Location, vect(0,0,0), 'Fell');
			P.ClientMessage(DeathMessage, 'Pickup');
			P.PlaySound(Sound'UnrealShare.Gibs.Gib1',,2.0);
			}
		else if ( !P.PlayerReplicationInfo.bIsSpectator && !bSpawning )
			P.Health--;
		if ( P.Health < 0 )
			P.Health = 0;
		}
	
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int CurrentHealth;

	if ( InstigatedBy != Victim )
     		{
		CurrentHealth = Victim.Health;
		if ( ActualDamage > CurrentHealth )
			{
			InstigatedBy.Health += CurrentHealth;
			}
		else
			{
			InstigatedBy.Health += ActualDamage;
			}
		if ( InstigatedBy.Health > MaxHealth )
			{
			InstigatedBy.Health = MaxHealth;
			}
     		}

	Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);

	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}
